function validaCpfCnpj(val) {
    val = val.replace(/-| |\.|\/|_|\(|\)/gi, "");
    if (val.length == 14) {
        var cpf = val.trim();
     
        cpf = cpf.replace(/\./g, '');
        cpf = cpf.replace('-', '');
        cpf = cpf.split('');
        
        var v1 = 0;
        var v2 = 0;
        var aux = false;
        
        for (var i = 1; cpf.length > i; i++) {
            if (cpf[i - 1] != cpf[i]) {
                aux = true;   
            }
        } 
        
        if (aux == false) {
            return false; 
        } 
        
        for (var i = 0, p = 10; (cpf.length - 2) > i; i++, p--) {
            v1 += cpf[i] * p; 
        } 
        
        v1 = ((v1 * 10) % 11);
        
        if (v1 == 10) {
            v1 = 0; 
        }
        
        if (v1 != cpf[9]) {
            return false; 
        } 
        
        for (var i = 0, p = 11; (cpf.length - 1) > i; i++, p--) {
            v2 += cpf[i] * p; 
        } 
        
        v2 = ((v2 * 10) % 11);
        
        if (v2 == 10) {
            v2 = 0; 
        }
        
        if (v2 != cpf[10]) {
            return false; 
        } else {   
            return true; 
        }
    } else if (val.length == 18) {
        var cnpj = val.trim();
        
        cnpj = cnpj.replace(/\./g, '');
        cnpj = cnpj.replace('-', '');
        cnpj = cnpj.replace('/', ''); 
        cnpj = cnpj.split(''); 
        
        var v1 = 0;
        var v2 = 0;
        var aux = false;
        
        for (var i = 1; cnpj.length > i; i++) { 
            if (cnpj[i - 1] != cnpj[i]) {  
                aux = true;   
            } 
        } 
        
        if (aux == false) {  
            return false; 
        }
        
        for (var i = 0, p1 = 5, p2 = 13; (cnpj.length - 2) > i; i++, p1--, p2--) {
            if (p1 >= 2) {  
                v1 += cnpj[i] * p1;  
            } else {  
                v1 += cnpj[i] * p2;  
            } 
        } 
        
        v1 = (v1 % 11);
        
        if (v1 < 2) { 
            v1 = 0; 
        } else { 
            v1 = (11 - v1); 
        } 
        
        if (v1 != cnpj[12]) {  
            return false; 
        } 
        
        for (var i = 0, p1 = 6, p2 = 14; (cnpj.length - 1) > i; i++, p1--, p2--) { 
            if (p1 >= 2) {  
                v2 += cnpj[i] * p1;  
            } else {   
                v2 += cnpj[i] * p2; 
            } 
        }
        
        v2 = (v2 % 11); 
        
        if (v2 < 2) {  
            v2 = 0;
        } else { 
            v2 = (11 - v2); 
        } 
        
        if (v2 != cnpj[13]) {   
            return false; 
        } else {  
            return true; 
        }
    } else {
        return false;
    }
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaEmail(valor) {
    var validRegex = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/;
    if (valor.match(validRegex)) {
        return true;
    } else {
        return false;
    }
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaUrl(valor) {
    var validRegex = /(http(s)?:\/\/.)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g;
    if (valor.match(validRegex)) {
        return true;
    } else {
        return false;
    }
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaCnpj(value) {
    var retorno = true;
    value = value.replace(/-| |\.|\/|_|\(|\)/gi, "");
	value = value.replace( /[^\d]+/g, "" );
	if ( value.length !== 14 ) {
		retorno = false;
	}
	if ( value === "00000000000000" ||
		value === "11111111111111" ||
		value === "22222222222222" ||
		value === "33333333333333" ||
		value === "44444444444444" ||
		value === "55555555555555" ||
		value === "66666666666666" ||
		value === "77777777777777" ||
		value === "88888888888888" ||
		value === "99999999999999" ) {
        retorno = false;
	}
	var tamanho = ( value.length - 2 );
	var numeros = value.substring( 0, tamanho );
	var digitos = value.substring( tamanho );
	var soma = 0;
	var pos = tamanho - 7;
	for ( var i = tamanho; i >= 1; i-- ) {
		soma += numeros.charAt( tamanho - i ) * pos--;
		if ( pos < 2 ) {
			pos = 9;
		}
	}
	var resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
	if ( resultado !== parseInt( digitos.charAt( 0 ), 10 ) ) {
		retorno = false;
	}
	tamanho = tamanho + 1;
	numeros = value.substring( 0, tamanho );
	soma = 0;
	pos = tamanho - 7;
	for ( var il = tamanho; il >= 1; il-- ) {
		soma += numeros.charAt( tamanho - il ) * pos--;
		if ( pos < 2 ) {
			pos = 9;
		}
	}
	resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
	if ( resultado !== parseInt( digitos.charAt( 1 ), 10 ) ) {
		retorno = false;
	}
	return retorno;
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaCpf(value) {
    var retorno = true;
    value = value.replace(/-| |\.|\/|_|\(|\)/gi, "");
	value = value.replace( /([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g, "" );
	if ( value.length !== 11 ) {
		retorno = false;
	}
	var sum = 0, firstCN, secondCN, checkResult, i;
	firstCN = parseInt( value.substring( 9, 10 ), 10 );
	secondCN = parseInt( value.substring( 10, 11 ), 10 );
	checkResult = function( sum, cn ) {
		var result = ( sum * 10 ) % 11;
		if ( ( result === 10 ) || ( result === 11 ) ) {
			result = 0;
		}
		return (result === cn);
	};
	if ( value === "" ||
		value === "00000000000" ||
		value === "11111111111" ||
		value === "22222222222" ||
		value === "33333333333" ||
		value === "44444444444" ||
		value === "55555555555" ||
		value === "66666666666" ||
		value === "77777777777" ||
		value === "88888888888" ||
		value === "99999999999"
	) {
		retorno = false;
	}
	for ( i = 1; i <= 9; i++ ) {
		sum = sum + parseInt( value.substring( i - 1, i ), 10 ) * ( 11 - i );
	}
	if (checkResult(sum, firstCN)) {
		sum = 0;
		for ( i = 1; i <= 10; i++ ) {
			sum = sum + parseInt( value.substring( i - 1, i ), 10 ) * ( 12 - i );
		}
		retorno = checkResult(sum,secondCN);
	}
	return retorno;
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaCns(value) {
    var retorno = true;
    value = value.replace(/-| |\.|\/|_|\(|\)/gi, "");
	value = value.replace( /[^\d]+/g, "" );
	if ( value.length !== 15 ) {
		retorno = false;
	}
	if ( value === "000000000000000" ||
		value === "111111111111111" ||
		value === "222222222222222" ||
		value === "333333333333333" ||
		value === "444444444444444" ||
		value === "555555555555555" ||
		value === "666666666666666" ||
		value === "777777777777777" ||
		value === "888888888888888" ||
		value === "999999999999999" ) {
        retorno = false;
	}

	if (value.substring(0,1) == 1 || value.substring(0,1) == 2){
		var resultado = "";
		var pis = value.substring(0,11);
		var soma = parseInt(value.substring(0,1)) * 15;
		soma = soma + parseInt(value.substring(1,2)) * 14;
		soma = soma + parseInt(value.substring(2,3)) * 13;
		soma = soma + parseInt(value.substring(3,4)) * 12;
		soma = soma + parseInt(value.substring(4,5)) * 11;
		soma = soma + parseInt(value.substring(5,6)) * 10;
		soma = soma + parseInt(value.substring(6,7)) * 9;
		soma = soma + parseInt(value.substring(7,8)) * 8;
		soma = soma + parseInt(value.substring(8,9)) * 7;
		soma = soma + parseInt(value.substring(9,10)) * 6;
		soma = soma + parseInt(value.substring(10,11)) * 5;
		var resto = soma % 11;
		var dv = 11 - resto;
		if (dv == 11){
			dv = 0;
		}
		if (dv == 10){
			soma = soma + 2;
			resto = soma % 11;
			dv = 11 - resto;
			resultado = pis + "001" + dv.toString();
		}
		else{
			resultado = pis + "000" + dv.toString();
		}
		if (value != resultado){
			retorno = false;
		}
	} else {
		if (value.substring(0,1) == 7 || value.substring(0,1) == 8 || value.substring(0,1) == 9){
			var soma = parseInt(value.substring(0,1)) * 15;
			soma = soma + parseInt(value.substring(1,2)) * 14;
			soma = soma + parseInt(value.substring(2,3)) * 13;
			soma = soma + parseInt(value.substring(3,4)) * 12;
			soma = soma + parseInt(value.substring(4,5)) * 11;
			soma = soma + parseInt(value.substring(5,6)) * 10;
			soma = soma + parseInt(value.substring(6,7)) * 9;
			soma = soma + parseInt(value.substring(7,8)) * 8;
			soma = soma + parseInt(value.substring(8,9)) * 7;
			soma = soma + parseInt(value.substring(9,10)) * 6;
			soma = soma + parseInt(value.substring(10,11)) * 5;
			soma = soma + parseInt(value.substring(11,12)) * 4;
			soma = soma + parseInt(value.substring(12,13)) * 3;
			soma = soma + parseInt(value.substring(13,14)) * 2;
			soma = soma + parseInt(value.substring(14,15)) * 1;
			var resto = soma % 11;
			if (resto != 0){
				retorno = false;
			}
		} else {
			retorno = false;
		}
	}
	return retorno;
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaCnh(value){
    var retorno = true;
    value = value.replace(/-| |\.|\/|_|\(|\)/gi, "");
    value = value.replace( /([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g, "" );
    if ( value.length !== 11 ) {
        retorno = false;
    }
    var sum = 0, dsc = 0, firstChar, firstCN, secondCN, i, j, v;
    firstChar = value.charAt( 0 );
    if ( new Array( 12 ).join( firstChar ) === value ) {
        retorno = false;
    }
    for ( i = 0, j = 9, v = 0; i < 9; ++i, --j ) {
      sum += +( value.charAt( i ) * j );
    }
    firstCN = sum % 11;
    if ( firstCN >= 10 ) {
      firstCN = 0;
      dsc = 2;
    }
    sum = 0;
    for ( i = 0, j = 1, v = 0; i < 9; ++i, ++j ) {
      sum += +( value.charAt( i ) * j );
    }
    secondCN = sum % 11;
    if ( secondCN >= 10 ) {
      secondCN = 0;
    } else {
      secondCN = secondCN - dsc;
    }
    retorno = (String( firstCN ).concat( secondCN ) === value.substr( -2 ));
    return retorno;
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaCelular(value){
    var nvalue = value.replace(/-| |\.|\/|_|\(|\)/gi, "");
    if (nvalue.length == 11){
        var fvalue = nvalue.substring(3);
        if (
            fvalue == "00000000" ||
            fvalue == "11111111" ||
            fvalue == "22222222" ||
            fvalue == "33333333" ||
            fvalue == "44444444" ||
            fvalue == "55555555" ||
            fvalue == "66666666" ||
            fvalue == "77777777" ||
            fvalue == "88888888" ||
            fvalue == "99999999"
        ){
            nvalue = 'x';
        }
    }
    return /^([14689][0-9]|2[12478]|3([1-5]|[7-8])|5([13-5])|7[193-7])9[0-9]{8}$/.test(nvalue);
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaData(value){
    return /^(?:(?:31(\/|-|\.)(?:0?[13578]|1[02]))\1|(?:(?:29|30)(\/|-|\.)(?:0?[1,3-9]|1[0-2])\2))(?:(?:1[6-9]|[2-9]\d)?\d{2})$|^(?:29(\/|-|\.)0?2\3(?:(?:(?:1[6-9]|[2-9]\d)?(?:0[48]|[2468][048]|[13579][26])|(?:(?:16|[2468][048]|[3579][26])00))))$|^(?:0?[1-9]|1\d|2[0-8])(\/|-|\.)(?:(?:0?[1-9])|(?:1[0-2]))\4(?:(?:1[6-9]|[2-9]\d)?\d{2})$/.test(value);
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function validaIdade(value, params){
    var dob = new Date(value);
    //var nvalue = dob.toLocaleString("en-CA");
    var month_diff = Date.now() - dob.getTime();
    var age_dt = new Date(month_diff); 
    var year = age_dt.getUTCFullYear();
    var getAge = Math.abs(year - 1970);
    return getAge >= params;
}
// *******************************************************************************************************************
// *******************************************************************************************************************
function pegaIdade(dateString) {
    var today = new Date();
    var birthDate = new Date(dateString);
    var age = today.getFullYear() - birthDate.getFullYear();
    var m = today.getMonth() - birthDate.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
        age--;
    }
    return age;
}